!function(root){"use strict";function Lexer(options){this.tokens=[],this.tokens.links={},this.options=options||marked.defaults,this.rules=block.normal,this.options.gfm&&(this.options.tables?this.rules=block.tables:this.rules=block.gfm)}function InlineLexer(links,options){if(this.options=options||marked.defaults,this.links=links,this.rules=inline.normal,this.renderer=this.options.renderer||new Renderer,this.renderer.options=this.options,!this.links)throw new Error("Tokens array requires a `links` property.");this.options.gfm?this.options.breaks?this.rules=inline.breaks:this.rules=inline.gfm:this.options.pedantic&&(this.rules=inline.pedantic)}function Renderer(options){this.options=options||{}}function TextRenderer(){}function Parser(options){this.tokens=[],this.token=null,this.options=options||marked.defaults,this.options.renderer=this.options.renderer||new Renderer,this.renderer=this.options.renderer,this.renderer.options=this.options}function escape(html,encode){return html.replace(encode?/&/g:/&(?!#?\w+;)/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}function unescape(html){return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi,function(_,n){return n=n.toLowerCase(),"colon"===n?":":"#"===n.charAt(0)?"x"===n.charAt(1)?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1)):""})}function edit(regex,opt){return regex=regex.source,opt=opt||"",{replace:function(name,val){return val=val.source||val,val=val.replace(/(^|[^\[])\^/g,"$1"),regex=regex.replace(name,val),this},getRegex:function(){return new RegExp(regex,opt)}}}function resolveUrl(base,href){return baseUrls[" "+base]||(/^[^:]+:\/*[^/]*$/.test(base)?baseUrls[" "+base]=base+"/":baseUrls[" "+base]=base.replace(/[^/]*$/,"")),base=baseUrls[" "+base],"//"===href.slice(0,2)?base.replace(/:[\s\S]*/,":")+href:"/"===href.charAt(0)?base.replace(/(:\/*[^/]*)[\s\S]*/,"$1")+href:base+href}function noop(){}function merge(obj){for(var target,key,i=1;i<arguments.length;i++){target=arguments[i];for(key in target)Object.prototype.hasOwnProperty.call(target,key)&&(obj[key]=target[key])}return obj}function marked(src,opt,callback){if(void 0===src||null===src)throw new Error("marked(): input parameter is undefined or null");if("string"!=typeof src)throw new Error("marked(): input parameter is of type "+Object.prototype.toString.call(src)+", string expected");if(callback||"function"==typeof opt){callback||(callback=opt,opt=null),opt=merge({},marked.defaults,opt||{});var tokens,pending,highlight=opt.highlight,i=0;try{tokens=Lexer.lex(src,opt)}catch(e){return callback(e)}pending=tokens.length;var done=function(err){if(err)return opt.highlight=highlight,callback(err);var out;try{out=Parser.parse(tokens,opt)}catch(e){err=e}return opt.highlight=highlight,err?callback(err):callback(null,out)};if(!highlight||highlight.length<3)return done();if(delete opt.highlight,!pending)return done();for(;i<tokens.length;i++)!function(token){"code"!==token.type?--pending||done():highlight(token.text,token.lang,function(err,code){return err?done(err):null==code||code===token.text?--pending||done():(token.text=code,token.escaped=!0,void(--pending||done()))})}(tokens[i])}else try{return opt&&(opt=merge({},marked.defaults,opt)),Parser.parse(Lexer.lex(src,opt),opt)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",(opt||marked.defaults).silent)return"<p>An error occurred:</p><pre>"+escape(e.message+"",!0)+"</pre>";throw e}}var block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,nptable:noop,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,html:/^ *(?:comment *(?:\n|\s*$)|closed *(?:\n{2,}|\s*$)|closing *(?:\n{2,}|\s*$))/,def:/^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,table:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,paragraph:/^([^\n]+(?:\n?(?!hr|heading|lheading| {0,3}>|tag)[^\n]+)+)/,text:/^[^\n]+/};block._label=/(?:\\[\[\]]|[^\[\]])+/,block._title=/(?:"(?:\\"|[^"]|"[^"\n]*")*"|'\n?(?:[^'\n]+\n?)*'|\([^()]*\))/,block.def=edit(block.def).replace("label",block._label).replace("title",block._title).getRegex(),block.bullet=/(?:[*+-]|\d+\.)/,block.item=/^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/,block.item=edit(block.item,"gm").replace(/bull/g,block.bullet).getRegex(),block.list=edit(block.list).replace(/bull/g,block.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+block.def.source+")").getRegex(),block._tag="(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b",block.html=edit(block.html).replace("comment",/<!--[\s\S]*?-->/).replace("closed",/<(tag)[\s\S]+?<\/\1>/).replace("closing",/<tag(?:"[^"]*"|'[^']*'|\s[^'"\/>\s]*)*?\/?>/).replace(/tag/g,block._tag).getRegex(),block.paragraph=edit(block.paragraph).replace("hr",block.hr).replace("heading",block.heading).replace("lheading",block.lheading).replace("tag","<"+block._tag).getRegex(),block.blockquote=edit(block.blockquote).replace("paragraph",block.paragraph).getRegex(),block.normal=merge({},block),block.gfm=merge({},block.normal,{fences:/^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\n? *\1 *(?:\n+|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/}),block.gfm.paragraph=edit(block.paragraph).replace("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|").getRegex(),block.tables=merge({},block.gfm,{nptable:/^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,table:/^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/}),Lexer.rules=block,Lexer.lex=function(src,options){return new Lexer(options).lex(src)},Lexer.prototype.lex=function(src){return src=src.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n"),this.token(src,!0)},Lexer.prototype.token=function(src,top){src=src.replace(/^ +$/gm,"");for(var next,loose,cap,bull,b,item,space,i,tag,l,isordered;src;)if((cap=this.rules.newline.exec(src))&&(src=src.substring(cap[0].length),cap[0].length>1&&this.tokens.push({type:"space"})),cap=this.rules.code.exec(src))src=src.substring(cap[0].length),cap=cap[0].replace(/^ {4}/gm,""),this.tokens.push({type:"code",text:this.options.pedantic?cap:cap.replace(/\n+$/,"")});else if(cap=this.rules.fences.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"code",lang:cap[2],text:cap[3]||""});else if(cap=this.rules.heading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:cap[1].length,text:cap[2]});else if(top&&(cap=this.rules.nptable.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].split(/ *\| */);this.tokens.push(item)}else if(cap=this.rules.hr.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"hr"});else if(cap=this.rules.blockquote.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"blockquote_start"}),cap=cap[0].replace(/^ *> ?/gm,""),this.token(cap,top),this.tokens.push({type:"blockquote_end"});else if(cap=this.rules.list.exec(src)){for(src=src.substring(cap[0].length),bull=cap[2],isordered=bull.length>1,this.tokens.push({type:"list_start",ordered:isordered,start:isordered?+bull:""}),cap=cap[0].match(this.rules.item),next=!1,l=cap.length,i=0;i<l;i++)item=cap[i],space=item.length,item=item.replace(/^ *([*+-]|\d+\.) +/,""),~item.indexOf("\n ")&&(space-=item.length,item=this.options.pedantic?item.replace(/^ {1,4}/gm,""):item.replace(new RegExp("^ {1,"+space+"}","gm"),"")),this.options.smartLists&&i!==l-1&&(b=block.bullet.exec(cap[i+1])[0],bull===b||bull.length>1&&b.length>1||(src=cap.slice(i+1).join("\n")+src,i=l-1)),loose=next||/\n\n(?!\s*$)/.test(item),i!==l-1&&(next="\n"===item.charAt(item.length-1),loose||(loose=next)),this.tokens.push({type:loose?"loose_item_start":"list_item_start"}),this.token(item,!1),this.tokens.push({type:"list_item_end"});this.tokens.push({type:"list_end"})}else if(cap=this.rules.html.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:this.options.sanitize?"paragraph":"html",pre:!this.options.sanitizer&&("pre"===cap[1]||"script"===cap[1]||"style"===cap[1]),text:cap[0]});else if(top&&(cap=this.rules.def.exec(src)))src=src.substring(cap[0].length),cap[3]&&(cap[3]=cap[3].substring(1,cap[3].length-1)),tag=cap[1].toLowerCase(),this.tokens.links[tag]||(this.tokens.links[tag]={href:cap[2],title:cap[3]});else if(top&&(cap=this.rules.table.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/(?: *\| *)?\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].replace(/^ *\| *| *\| *$/g,"").split(/ *\| */);this.tokens.push(item)}else if(cap=this.rules.lheading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:"="===cap[2]?1:2,text:cap[1]});else if(top&&(cap=this.rules.paragraph.exec(src)))src=src.substring(cap[0].length),this.tokens.push({type:"paragraph",text:"\n"===cap[1].charAt(cap[1].length-1)?cap[1].slice(0,-1):cap[1]});else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"text",text:cap[0]});else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0));return this.tokens};var inline={escape:/^\\([\\`*{}\[\]()#+\-.!_>])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:noop,tag:/^<!--[\s\S]*?-->|^<\/?[a-zA-Z0-9\-]+(?:"[^"]*"|'[^']*'|\s[^<'">\/\s]*)*?\/?>/,link:/^!?\[(inside)\]\(href\)/,reflink:/^!?\[(inside)\]\s*\[([^\]]*)\]/,nolink:/^!?\[((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\]/,strong:/^__([\s\S]+?)__(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,em:/^_([^\s_](?:[^_]|__)+?[^\s_])_\b|^\*((?:\*\*|[^*])+?)\*(?!\*)/,code:/^(`+)\s*([\s\S]*?[^`]?)\s*\1(?!`)/,br:/^ {2,}\n(?!\s*$)/,del:noop,text:/^[\s\S]+?(?=[\\<!\[`*]|\b_| {2,}\n|$)/};inline._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,inline._email=/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,inline.autolink=edit(inline.autolink).replace("scheme",inline._scheme).replace("email",inline._email).getRegex(),inline._inside=/(?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]]|\](?=[^\[]*\]))*/,inline._href=/\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/,inline.link=edit(inline.link).replace("inside",inline._inside).replace("href",inline._href).getRegex(),inline.reflink=edit(inline.reflink).replace("inside",inline._inside).getRegex(),inline.normal=merge({},inline),inline.pedantic=merge({},inline.normal,{strong:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/}),inline.gfm=merge({},inline.normal,{escape:edit(inline.escape).replace("])","~|])").getRegex(),url:edit(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/).replace("email",inline._email).getRegex(),_backpedal:/(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,del:/^~~(?=\S)([\s\S]*?\S)~~/,text:edit(inline.text).replace("]|","~]|").replace("|","|https?://|ftp://|www\\.|[a-zA-Z0-9.!#$%&'*+/=?^_`{\\|}~-]+@|").getRegex()}),inline.breaks=merge({},inline.gfm,{br:edit(inline.br).replace("{2,}","*").getRegex(),text:edit(inline.gfm.text).replace("{2,}","*").getRegex()}),InlineLexer.rules=inline,InlineLexer.output=function(src,links,options){return new InlineLexer(links,options).output(src)},InlineLexer.prototype.output=function(src){for(var link,text,href,cap,out="";src;)if(cap=this.rules.escape.exec(src))src=src.substring(cap[0].length),out+=cap[1];else if(cap=this.rules.autolink.exec(src))src=src.substring(cap[0].length),"@"===cap[2]?(text=escape(this.mangle(cap[1])),href="mailto:"+text):(text=escape(cap[1]),href=text),out+=this.renderer.link(href,null,text);else if(this.inLink||!(cap=this.rules.url.exec(src))){if(cap=this.rules.tag.exec(src))!this.inLink&&/^<a /i.test(cap[0])?this.inLink=!0:this.inLink&&/^<\/a>/i.test(cap[0])&&(this.inLink=!1),src=src.substring(cap[0].length),out+=this.options.sanitize?this.options.sanitizer?this.options.sanitizer(cap[0]):escape(cap[0]):cap[0];else if(cap=this.rules.link.exec(src))src=src.substring(cap[0].length),this.inLink=!0,out+=this.outputLink(cap,{href:cap[2],title:cap[3]}),this.inLink=!1;else if((cap=this.rules.reflink.exec(src))||(cap=this.rules.nolink.exec(src))){if(src=src.substring(cap[0].length),link=(cap[2]||cap[1]).replace(/\s+/g," "),!(link=this.links[link.toLowerCase()])||!link.href){out+=cap[0].charAt(0),src=cap[0].substring(1)+src;continue}this.inLink=!0,out+=this.outputLink(cap,link),this.inLink=!1}else if(cap=this.rules.strong.exec(src))src=src.substring(cap[0].length),out+=this.renderer.strong(this.output(cap[2]||cap[1]));else if(cap=this.rules.em.exec(src))src=src.substring(cap[0].length),out+=this.renderer.em(this.output(cap[2]||cap[1]));else if(cap=this.rules.code.exec(src))src=src.substring(cap[0].length),out+=this.renderer.codespan(escape(cap[2].trim(),!0));else if(cap=this.rules.br.exec(src))src=src.substring(cap[0].length),out+=this.renderer.br();else if(cap=this.rules.del.exec(src))src=src.substring(cap[0].length),out+=this.renderer.del(this.output(cap[1]));else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),out+=this.renderer.text(escape(this.smartypants(cap[0])));else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}else cap[0]=this.rules._backpedal.exec(cap[0])[0],src=src.substring(cap[0].length),"@"===cap[2]?(text=escape(cap[0]),href="mailto:"+text):(text=escape(cap[0]),href="www."===cap[1]?"http://"+text:text),out+=this.renderer.link(href,null,text);return out},InlineLexer.prototype.outputLink=function(cap,link){var href=escape(link.href),title=link.title?escape(link.title):null;return"!"!==cap[0].charAt(0)?this.renderer.link(href,title,this.output(cap[1])):this.renderer.image(href,title,escape(cap[1]))},InlineLexer.prototype.smartypants=function(text){return this.options.smartypants?text.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…"):text},InlineLexer.prototype.mangle=function(text){if(!this.options.mangle)return text;for(var ch,out="",l=text.length,i=0;i<l;i++)ch=text.charCodeAt(i),Math.random()>.5&&(ch="x"+ch.toString(16)),out+="&#"+ch+";";return out},Renderer.prototype.code=function(code,lang,escaped){if(this.options.highlight){var out=this.options.highlight(code,lang);null!=out&&out!==code&&(escaped=!0,code=out)}return lang?'<pre><code class="'+this.options.langPrefix+escape(lang,!0)+'">'+(escaped?code:escape(code,!0))+"\n</code></pre>\n":"<pre><code>"+(escaped?code:escape(code,!0))+"\n</code></pre>"},Renderer.prototype.blockquote=function(quote){return"<blockquote>\n"+quote+"</blockquote>\n"},Renderer.prototype.html=function(html){return html},Renderer.prototype.heading=function(text,level,raw){return"<h"+level+' id="'+this.options.headerPrefix+raw.toLowerCase().replace(/[^\w]+/g,"-")+'">'+text+"</h"+level+">\n"},Renderer.prototype.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},Renderer.prototype.list=function(body,ordered,start){var type=ordered?"ol":"ul";return"<"+type+(ordered&&1!==start?' start="'+start+'"':"")+">\n"+body+"</"+type+">\n"},Renderer.prototype.listitem=function(text){return"<li>"+text+"</li>\n"},Renderer.prototype.paragraph=function(text){return"<p>"+text+"</p>\n"},Renderer.prototype.table=function(header,body){return"<table>\n<thead>\n"+header+"</thead>\n<tbody>\n"+body+"</tbody>\n</table>\n"},Renderer.prototype.tablerow=function(content){return"<tr>\n"+content+"</tr>\n"},Renderer.prototype.tablecell=function(content,flags){var type=flags.header?"th":"td";return(flags.align?"<"+type+' style="text-align:'+flags.align+'">':"<"+type+">")+content+"</"+type+">\n"},Renderer.prototype.strong=function(text){return"<strong>"+text+"</strong>"},Renderer.prototype.em=function(text){return"<em>"+text+"</em>"},Renderer.prototype.codespan=function(text){return"<code>"+text+"</code>"},Renderer.prototype.br=function(){return this.options.xhtml?"<br/>":"<br>"},Renderer.prototype.del=function(text){return"<del>"+text+"</del>"},Renderer.prototype.link=function(href,title,text){if(this.options.sanitize){try{var prot=decodeURIComponent(unescape(href)).replace(/[^\w:]/g,"").toLowerCase()}catch(e){return text}if(0===prot.indexOf("javascript:")||0===prot.indexOf("vbscript:")||0===prot.indexOf("data:"))return text}this.options.baseUrl&&!originIndependentUrl.test(href)&&(href=resolveUrl(this.options.baseUrl,href));var out='<a href="'+href+'"';return title&&(out+=' title="'+title+'"'),out+=">"+text+"</a>"},Renderer.prototype.image=function(href,title,text){this.options.baseUrl&&!originIndependentUrl.test(href)&&(href=resolveUrl(this.options.baseUrl,href));var out='<img src="'+href+'" alt="'+text+'"';return title&&(out+=' title="'+title+'"'),out+=this.options.xhtml?"/>":">"},Renderer.prototype.text=function(text){return text},TextRenderer.prototype.strong=TextRenderer.prototype.em=TextRenderer.prototype.codespan=TextRenderer.prototype.del=TextRenderer.prototype.text=function(text){return text},TextRenderer.prototype.link=TextRenderer.prototype.image=function(href,title,text){return""+text},TextRenderer.prototype.br=function(){return""},Parser.parse=function(src,options){return new Parser(options).parse(src)},Parser.prototype.parse=function(src){this.inline=new InlineLexer(src.links,this.options),this.inlineText=new InlineLexer(src.links,merge({},this.options,{renderer:new TextRenderer})),this.tokens=src.reverse();for(var out="";this.next();)out+=this.tok();return out},Parser.prototype.next=function(){return this.token=this.tokens.pop()},Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0},Parser.prototype.parseText=function(){for(var body=this.token.text;"text"===this.peek().type;)body+="\n"+this.next().text;return this.inline.output(body)},Parser.prototype.tok=function(){switch(this.token.type){case"space":return"";case"hr":return this.renderer.hr();case"heading":return this.renderer.heading(this.inline.output(this.token.text),this.token.depth,unescape(this.inlineText.output(this.token.text)));case"code":return this.renderer.code(this.token.text,this.token.lang,this.token.escaped);case"table":var i,row,cell,j,header="",body="";for(cell="",i=0;i<this.token.header.length;i++)cell+=this.renderer.tablecell(this.inline.output(this.token.header[i]),{header:!0,align:this.token.align[i]});for(header+=this.renderer.tablerow(cell),i=0;i<this.token.cells.length;i++){for(row=this.token.cells[i],cell="",j=0;j<row.length;j++)cell+=this.renderer.tablecell(this.inline.output(row[j]),{header:!1,align:this.token.align[j]});body+=this.renderer.tablerow(cell)}return this.renderer.table(header,body);case"blockquote_start":for(body="";"blockquote_end"!==this.next().type;)body+=this.tok();return this.renderer.blockquote(body);case"list_start":body="";for(var ordered=this.token.ordered,start=this.token.start;"list_end"!==this.next().type;)body+=this.tok();return this.renderer.list(body,ordered,start);case"list_item_start":for(body="";"list_item_end"!==this.next().type;)body+="text"===this.token.type?this.parseText():this.tok();return this.renderer.listitem(body);case"loose_item_start":for(body="";"list_item_end"!==this.next().type;)body+=this.tok();return this.renderer.listitem(body);case"html":var html=this.token.pre||this.options.pedantic?this.token.text:this.inline.output(this.token.text);return this.renderer.html(html);case"paragraph":return this.renderer.paragraph(this.inline.output(this.token.text));case"text":return this.renderer.paragraph(this.parseText())}};var baseUrls={},originIndependentUrl=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;noop.exec=noop,marked.options=marked.setOptions=function(opt){return merge(marked.defaults,opt),marked},marked.defaults={gfm:!0,tables:!0,breaks:!1,pedantic:!1,sanitize:!1,sanitizer:null,mangle:!0,smartLists:!1,silent:!1,highlight:null,langPrefix:"lang-",smartypants:!1,headerPrefix:"",renderer:new Renderer,xhtml:!1,baseUrl:null},marked.Parser=Parser,marked.parser=Parser.parse,marked.Renderer=Renderer,marked.TextRenderer=TextRenderer,marked.Lexer=Lexer,marked.lexer=Lexer.lex,marked.InlineLexer=InlineLexer,marked.inlineLexer=InlineLexer.output,marked.parse=marked,"undefined"!=typeof module&&"object"==typeof exports?module.exports=marked:"function"==typeof define&&define.amd?define(function(){return marked}):root.marked=marked}(this||("undefined"!=typeof window?window:global)),$(document).ready(function(){var formatBytes=function(bytes){return bytes>1e9?(Math.round(bytes/1e8)/10).toLocaleString()+" GB":bytes>1e6?(Math.round(bytes/1e5)/10).toLocaleString()+" MB":bytes>1e3?(Math.round(bytes/100)/10).toLocaleString()+" KB":bytes.toLocaleString()+" bytes"},roomMembers={},getAuthToken=function(config){return $.Deferred(function(defer){var existingToken=localStorage.getItem("access:"+config.homeserver);if(existingToken)return config.access_token=existingToken,void defer.resolve(existingToken);$.ajax({url:config.homeserver+"/_matrix/client/r0/register?kind=guest",type:"POST",contentType:"application/json",data:'{ "initial_device_display_name": "DIMOV Matrix Live Reader" }',processData:!1,dataType:"json"}).then(function(res){res.access_token?(localStorage.setItem("access:"+config.homeserver,res.access_token),config.access_token=res.access_token,defer.resolve(res.access_token)):(console.log("Received strange response from matrix: "),console.log(res),defer.reject())},defer.reject)}).promise()},processEvent=function(config,matrixEvent,mLiveBody,isUpdate){var newEntry,match,match2,myServerName,myMediaId,thumbnailServerName,thumbnailMediaId,linkNeeded,messageHtml;if("m.room.message"===matrixEvent.type&&matrixEvent.content&&"m.text"===matrixEvent.content.msgtype)messageHtml=marked(matrixEvent.content.body,{sanitize:!0}),messageHtml=messageHtml.replace(/<img [^>]*src=("[^"]*"|'[^']*')[^>]*>/i,function(fullTag,srcAttr){return(match=srcAttr.substr(1).match(/^https?:\/\/(www\.)?youtube\.com\/watch\?v=([a-zA-Z0-9_]+)/i))?'<div class="matrix-live-entry-inline-viewer"><iframe width="480" height="270" src="https://www.youtube.com/embed/'+match[2]+'" frameborder="0" allowfullscreen></iframe></div>':(match=srcAttr.substr(1).match(/^https?:\/\/(www\.)?vimeo\.com\/([0-9]+)/i))?'<div class="matrix-live-entry-inline-viewer"><iframe src="https://player.vimeo.com/video/'+match[2]+'?portrait=0" width="480" height="270" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>':(match=srcAttr.substr(1).match(/^https?:\/\/([a-z]+\.)?dailymotion\.com\/video\/([a-z0-9]+)_/i))?'<div class="matrix-live-entry-inline-viewer"><iframe frameborder="0" width="480" height="270" src="https://www.dailymotion.com/embed/video/'+match[2]+'" allowfullscreen></iframe></div>':fullTag}),newEntry=$('<div class="matrix-live-entry'+(isUpdate?" matrix-live-new":"")+'" matrix-event-id="'+matrixEvent.event_id.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"><div class="matrix-live-entry-body">'+messageHtml+'</div><div class="matrix-live-entry-author"></div><div class="matrix-live-entry-time">'+new Date(matrixEvent.origin_server_ts).toLocaleTimeString()+"</div></div>"),newEntry.children(".matrix-live-entry-author").text(void 0==roomMembers[matrixEvent.sender]||""==roomMembers[matrixEvent.sender]?matrixEvent.sender:roomMembers[matrixEvent.sender]),mLiveBody.prepend(newEntry);else if("m.room.message"===matrixEvent.type&&matrixEvent.content&&"m.image"===matrixEvent.content.msgtype){if(!(match=matrixEvent.content.url.match(/^mxc:\/\/([a-zA-Z0-9\.\-]+)\/([0-9a-zA-Z]+)$/i)))return;myServerName=match[1],myMediaId=match[2],linkNeeded=matrixEvent.content.info.w>700,newEntry=$('<div class="matrix-live-entry'+(isUpdate?" matrix-live-new":"")+'" matrix-event-id="'+matrixEvent.event_id.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"><div class="matrix-live-entry-image">'+(linkNeeded?'<a href="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" target="_blank">':"")+'<img src="'+config.homeserver+"/_matrix/media/r0/thumbnail/"+myServerName+"/"+myMediaId+'?width=700&height=700&method=scale">'+(linkNeeded?"</a>":"")+'</div><div class="matrix-live-entry-author"></div><div class="matrix-live-entry-time">'+new Date(matrixEvent.origin_server_ts).toLocaleTimeString()+"</div></div>"),newEntry.children(".matrix-live-entry-author").text(void 0==roomMembers[matrixEvent.sender]||""==roomMembers[matrixEvent.sender]?matrixEvent.sender:roomMembers[matrixEvent.sender]),mLiveBody.prepend(newEntry)}else if("m.room.message"===matrixEvent.type&&matrixEvent.content&&"m.video"===matrixEvent.content.msgtype){if(!(match=matrixEvent.content.url.match(/^mxc:\/\/([a-zA-Z0-9\.\-]+)\/([0-9a-zA-Z]+)$/i))||!(match2=matrixEvent.content.info.thumbnail_url.match(/^mxc:\/\/([a-zA-Z0-9\.\-]+)\/([0-9a-zA-Z]+)$/i)))return;myServerName=match[1],myMediaId=match[2],thumbnailServerName=match2[1],thumbnailMediaId=match2[2],newEntry=$('<div class="matrix-live-entry'+(isUpdate?" matrix-live-new":"")+'" matrix-event-id="'+matrixEvent.event_id.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"><div class="matrix-live-entry-video"><video src="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" poster="'+config.homeserver+"/_matrix/media/v1/download/"+thumbnailServerName+"/"+thumbnailMediaId+'" controls> [ <a href="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" target="_blank">Play Video</a> ]</video></div><div class="matrix-live-entry-author"></div><div class="matrix-live-entry-time">'+new Date(matrixEvent.origin_server_ts).toLocaleTimeString()+"</div></div>"),newEntry.children(".matrix-live-entry-author").text(void 0==roomMembers[matrixEvent.sender]||""==roomMembers[matrixEvent.sender]?matrixEvent.sender:roomMembers[matrixEvent.sender]),mLiveBody.prepend(newEntry)}else if("m.room.message"===matrixEvent.type&&matrixEvent.content&&"m.audio"===matrixEvent.content.msgtype){if(!(match=matrixEvent.content.url.match(/^mxc:\/\/([a-zA-Z0-9\.\-]+)\/([0-9a-zA-Z]+)$/i)))return;myServerName=match[1],myMediaId=match[2],newEntry=$('<div class="matrix-live-entry'+(isUpdate?" matrix-live-new":"")+'" matrix-event-id="'+matrixEvent.event_id.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"><div class="matrix-live-entry-video"><audio src="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" controls> [ <a href="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" target="_blank">Play Audio</a> ]</audio></div><div class="matrix-live-entry-author"></div><div class="matrix-live-entry-time">'+new Date(matrixEvent.origin_server_ts).toLocaleTimeString()+"</div></div>"),newEntry.children(".matrix-live-entry-author").text(void 0==roomMembers[matrixEvent.sender]||""==roomMembers[matrixEvent.sender]?matrixEvent.sender:roomMembers[matrixEvent.sender]),mLiveBody.prepend(newEntry)}else if("m.room.message"===matrixEvent.type&&matrixEvent.content&&"m.file"===matrixEvent.content.msgtype){if(!(match=matrixEvent.content.url.match(/^mxc:\/\/([a-zA-Z0-9\.\-]+)\/([0-9a-zA-Z]+)$/i)))return;myServerName=match[1],myMediaId=match[2],newEntry=$('<div class="matrix-live-entry'+(isUpdate?" matrix-live-new":"")+'" matrix-event-id="'+matrixEvent.event_id.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"><div class="matrix-live-entry-file"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 120 120" xml:space="preserve"> <polygon points="48.732,69.783 91.039,27.476 102.778,39.215 60.472,81.527 "/><rect x="50.999" y="3.424" width="19.055" height="60.21"/> <polygon points="60.543,81.572 18.22,39.283 29.941,27.542 72.271,69.85 "/> <rect x="9" y="99.575" width="103" height="17"/> <rect x="5.5" y="68.576" width="17" height="48"/> <rect x="97.5" y="68.576" width="17" height="48"/></svg><a href="'+config.homeserver+"/_matrix/media/r0/download/"+myServerName+"/"+myMediaId+'" target="_blank">Download <span class="matrix-live-filename"></span> ('+formatBytes(matrixEvent.content.info.size)+') </a></div><div class="matrix-live-entry-author"></div><div class="matrix-live-entry-time">'+new Date(matrixEvent.origin_server_ts).toLocaleTimeString()+"</div></div>"),newEntry.find(".matrix-live-filename").text(matrixEvent.content.body),newEntry.children(".matrix-live-entry-author").text(void 0==roomMembers[matrixEvent.sender]||""==roomMembers[matrixEvent.sender]?matrixEvent.sender:roomMembers[matrixEvent.sender]),mLiveBody.prepend(newEntry)}else"m.room.member"===matrixEvent.type&&"join"===matrixEvent.membership&&matrixEvent.content&&void 0!==matrixEvent.content.displayname?roomMembers[matrixEvent.user_id]=matrixEvent.content.displayname:"m.room.redaction"===matrixEvent.type&&mLiveBody.find('.matrix-live-entry[matrix-event-id="'+matrixEvent.redacts.replace(/[^a-zA-Z0-9:\-\._!$%+=]/g,"")+'"]').remove()},getInitialSync=function(config,mLiveBody,secondTry){return $.Deferred(function(defer){$.ajax({url:config.homeserver+"/_matrix/client/r0/rooms/"+encodeURIComponent(config.room)+"/initialSync?limit="+config.initial_load+"&access_token="+encodeURIComponent(config.access_token),type:"GET",dataType:"json"}).then(function(res){res.messages&&res.messages.chunk&&Array.isArray(res.messages.chunk)&&res.state&&Array.isArray(res.state)?(res.state.forEach(function(state){"m.room.member"===state.type&&"join"===state.membership&&state.content&&void 0!==state.content.displayname&&(roomMembers[state.user_id]=state.content.displayname)}),res.messages.chunk.forEach(function(evt){processEvent(config,evt,mLiveBody,!1)}),defer.resolve(res.messages.end)):(console.log("Received strange response from matrix: "),console.log(res),defer.reject())},function(err){403!==err.status||"M_UNKNOWN_TOKEN"!==err.responseJSON.errcode||secondTry?defer.reject():(localStorage.removeItem("access:"+config.homeserver),getAuthToken(config).then(function(){return getInitialSync(config,mLiveBody,!0)}).then(defer.resolve,defer.reject))})}).promise()},startEventLoop=function(config,initialStart,mLiveBody){var doLoop=function(defer,start){$.ajax({url:config.homeserver+"/_matrix/client/r0/events?room_id="+encodeURIComponent(config.room)+"&timeout=30000&from="+encodeURIComponent(start)+"&access_token="+encodeURIComponent(config.access_token),type:"GET",dataType:"json"}).then(function(res){res.chunk&&Array.isArray(res.chunk)?(res.chunk.forEach(function(evt){processEvent(config,evt,mLiveBody,!0)}),doLoop(defer,res.end)):(console.log("Received strange response from matrix: "),console.log(res),defer.reject())},defer.reject)};return $.Deferred(function(defer){doLoop(defer,initialStart)}).promise()},addMatrixLive=function(idx,ele){var origElement=$(ele),config={};config.homeserver=origElement.attr("homeserver")||"https://matrix.org",config.room=origElement.attr("room"),config.show_footer="false"!==origElement.attr("show-footer"),
config.initial_load=$.isNumeric(origElement.attr("initial-load"))?origElement.attr("initial-load"):60,config.homeserver=config.homeserver.replace(/\/$/,"");var mLive=$('<div class="matrix-live-main"><div class="matrix-live-loading">Loading...</div><div class="matrix-live-body"></div>'+(config.show_footer?'<div class="matrix-live-footer"><a href="https://live.dimov.xyz/" target="_blank">Powered by DIMOV Matrix Live</a></div>':"")+"</div>");origElement.replaceWith(mLive);var loadingIndicator=mLive.children(".matrix-live-loading"),mLiveBody=mLive.children(".matrix-live-body");config.access_token=void 0,getAuthToken(config).then(function(){return getInitialSync(config,mLiveBody)}).then(function(start){return loadingIndicator.html('Streaming live... &nbsp;&nbsp;&nbsp; <img width="12" height="12" src="data:image/gif;base64,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" class="matrix-live-loading-spinning">'),startEventLoop(config,start,mLiveBody)}).fail(function(){loadingIndicator.text("Disconnected."),loadingIndicator.addClass("matrix-live-loading-error"),mLiveBody.prepend('<div class="matrix-live-error">An error occured loading the live stream. Please reload or try again later.</div>')})};$("matrix-live").each(addMatrixLive)});